<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Kingsway Settings Class
 *
 * 处理插件的设置页面和 API 密钥管理
 *
 * @class Kingsway_Settings
 * @version 1.0.6
 * @package Kingsway_Plugin
 */
class Kingsway_Settings {

    /**
     * 构造函数，注册设置页面相关钩子
     */
    public function __construct() {
        add_filter('plugin_action_links_' . plugin_basename(KINGSWAY_PLUGIN_FILE), array($this, 'add_settings_link'));
        add_action('admin_menu', array($this, 'add_settings_page'));
        add_action('admin_init', array($this, 'register_settings'));
    }

    /**
     * 添加设置链接到插件列表
     *
     * @param array $links
     * @return array
     */
    public function add_settings_link($links) {
        $settings_link = '<a href="' . admin_url('options-general.php?page=kingsway-settings') . '">' . __('Settings', 'kingsway-plugin') . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }

    /**
     * 添加设置页面
     */
    public function add_settings_page() {
        add_options_page(
            __('Kingsway Settings', 'kingsway-plugin'),
            __('Kingsway', 'kingsway-plugin'),
            'manage_options',
            'kingsway-settings',
            array($this, 'settings_page_content')
        );
    }

    /**
     * 注册设置
     */
    public function register_settings() {
        register_setting('kingsway_settings_group', 'kingsway-wordpress-plugin-api-key', array(
            'sanitize_callback' => 'sanitize_text_field',
            'default' => '',
        ));
    }

    /**
     * 设置页面内容
     */
    public function settings_page_content() {
        // 保存设置
        if (isset($_POST['kingsway_api_key']) && check_admin_referer('kingsway_settings')) {
            update_option('kingsway-wordpress-plugin-api-key', sanitize_text_field($_POST['kingsway_api_key']));
            echo '<div class="notice notice-success"><p>' . __('Settings saved.', 'kingsway-plugin') . '</p></div>';
        }
        
        $api_key = get_option('kingsway-wordpress-plugin-api-key', '');
        ?>
        <div class="wrap">
            <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
            <form method="post" action="">
                <?php wp_nonce_field('kingsway_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="kingsway_api_key"><?php _e('API Key', 'kingsway-plugin'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="kingsway_api_key" name="kingsway_api_key" value="<?php echo esc_attr($api_key); ?>" class="regular-text" />
                            <p class="description"><?php _e('Enter your Kingsway API Key.', 'kingsway-plugin'); ?></p>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }

    /**
     * 获取 API 密钥
     *
     * @return string
     */
    public static function get_api_key() {
        return get_option('kingsway-wordpress-plugin-api-key', '');
    }
}
