<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Kingsway Gutenberg Support Class
 *
 * 处理 Gutenberg 块的注册和资源加载
 *
 * @class Kingsway_Gutenberg
 * @version 1.0.6
 * @package Kingsway_Plugin
 */
class Kingsway_Gutenberg {

    /**
     * 构造函数，注册 Gutenberg 相关钩子
     */
    public function __construct() {
        add_action('init', array($this, 'register_block'));
        add_action('enqueue_block_editor_assets', array($this, 'enqueue_block_assets'));
    }

    /**
     * 注册 Gutenberg 块
     */
    public function register_block() {
        // 使用 block.json 注册块
        register_block_type_from_metadata( __DIR__ . '/../' );
        
        // 或者直接注册块，确保块名称与 JavaScript 中一致
        register_block_type( 'my-custom/html-modal-block', array(
            'editor_script' => 'my-custom-block',
            'editor_style'  => 'kingsway-shared',
            'style'         => 'kingsway-shared',
            'attributes' => array(
                'htmlContent' => array(
                    'type' => 'string',
                    'default' => '',
                ),
                'embedType' => array(
                    'type' => 'string',
                    'default' => '',
                ),
            ),
            'render_callback' => function( $attributes ) {
                // 确保共享样式在前端加载
                if ( ! wp_style_is( 'kingsway-shared', 'enqueued' ) ) {
                    wp_enqueue_style( 'kingsway-shared' );
                }
                
                if ( ! isset( $attributes['htmlContent'] ) ) {
                    return '';
                }
                return '<div>' . $attributes['htmlContent'] . '</div>';
            },
        ) );

        register_post_meta('post', 'thumbnail_url', [
            'show_in_rest' => true, // 允许在 REST API 中访问
            'single'       => true, // 单一值
            'type'         => 'string', // 数据类型
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            },
        ]);
    }

    /**
     * 注册和加载 Gutenberg 块资产
     */
    public function enqueue_block_assets() {
        // 加载共用脚本和样式
        wp_enqueue_script('kingsway-library');
        wp_enqueue_style('kingsway-shared');
        
        wp_enqueue_script(
            'my-custom-block',
            KINGSWAY_URL . 'build/index.js',
            array('wp-blocks', 'wp-element', 'wp-editor', 'wp-server-side-render', 'wp-components', 'wp-api-fetch', 'kingsway-library'),
            filemtime(KINGSWAY_DIR . 'build/index.js')
        );

        wp_enqueue_style(
            'build-css',
            KINGSWAY_URL . 'build/index.css',
            array('kingsway-shared'),
            filemtime(KINGSWAY_DIR . 'build/index.css')
        );
    }
}
