;(function ($) {
  'use strict'

  // 工具函数：获取库实例
  function getLibrary() {
    return window.KingswayLibrary
  }

  // 工具函数：初始化库
  function initLibrary() {
    var lib = getLibrary()
    if (lib && typeof kingswayPlugin !== 'undefined') {
      lib.init({
        apiRoot: kingswayPlugin.apiRoot,
        nonce: kingswayPlugin.nonce,
        env: kingswayPlugin.env || 'production',
      })
    }
  }

  // 工具函数：根据资源类型获取内容类型
  function getContentType(resourceType) {
    if (resourceType === 'video') return 'video'
    if (resourceType === 'widget') return 'widget'
    return null
  }

  // 工具函数：更新表单字段
  function updateFormFields(type, item, html) {
    $('#kingsway_embed_type').val(type)
    $('#kingsway_html_content').val(html)

    var $itemTitle = $('#kingsway_item_title')
    var $currentAssociation = $('#kingsway-current-association')

    if (item && item.title) {
      $itemTitle.val(item.title)
      $currentAssociation.text(item.title)
    } else {
      $itemTitle.val('')
      $currentAssociation.text('Selected')
    }
  }

  // 工具函数：加载播放器脚本
  function loadPlayerScript(lib, type) {
    if (lib && lib.loadPlayerScript) {
      lib.loadPlayerScript(type)
    }
  }

  $(function () {
    var $resourceRadios = $('input[name="kingsway_resource_type"]')

    $('#kingsway-open-library').on('click', function (e) {
      e.preventDefault()

      initLibrary()
      var lib = getLibrary()
      if (!lib) {
        // eslint-disable-next-line no-console
        console.error('KingswayLibrary not loaded')
        return
      }

      var resourceType = $resourceRadios.filter(':checked').val() || null
      var contentType = getContentType(resourceType)

      lib.open({
        contentType: contentType,
        videoOptions: {},
        widgetOptions: {},
        onSelect: function (type, item, html) {
          updateFormFields(type, item, html)
          loadPlayerScript(lib, type)
        },
      })
    })
  })
})(jQuery)


